<?php

namespace Modules\SystemInfo\Livewire\Admin\Settings\System;

use Livewire\Component;
use Modules\SystemInfo\Services\SystemManagement;

class SystemInformationSettings extends Component
{
    public $system;

    public $server;

    public $packages;

    protected $systemManagement;

    public function mount(SystemManagement $systemManagement)
    {

        if (! checkPermission('system_settings.view')) {
            $this->notify(['type' => 'danger', 'message' => t('access_denied_note')], true);

            return redirect(route('admin.dashboard'));
        }
        $this->systemManagement = $systemManagement;

        $info         = $this->systemManagement->getInfo();
        $this->system = $info['system'];
        $this->server = $info['server'];
    }

    public function render()
    {
        return view('SystemInfo::livewire.admin.settings.system.system-information-settings');
    }
}
