<?php

namespace App\Livewire\Admin\FlowBot;

use App\Models\BotFlow;
use App\Rules\PurifiedInput;
use Livewire\Component;
use Livewire\WithPagination;

class FlowList extends Component
{
    use WithPagination;

    public BotFlow $botFlow;

    public $showSourceModal = false;

    public $confirmingDeletion = false;

    public $botFlowId = null;

    protected $listeners = [
        'editSource'    => 'editSource',
        'confirmDelete' => 'confirmDelete',
    ];

    public function mount()
    {

        $this->resetForm();
        $this->botFlow = new BotFlow;
    }

    protected function rules()
    {
        return [
            'botFlow.name' => [
                'required',
                'unique:sources,name,' . ($this->botFlow->id ?? 'NULL'),
                new PurifiedInput(t('sql_injection_error')),
                'max:150',
            ],
            'botFlow.description' => [
                'nullable',
                new PurifiedInput(t('sql_injection_error')),
                'max:150',
            ],
        ];
    }

    public function createSourcePage()
    {
        $this->resetForm();
        $this->showSourceModal = true;
    }

    public function save()
    {
        $this->validate();
        if ($this->botFlow->isDirty()) {
            $this->botFlow->flow_data = null;
            $this->botFlow->save();
            $this->showSourceModal = false;

            $message = $this->botFlow->wasRecentlyCreated
                ? t('bot_flow_saved_successfully')
                : t('bot_flow_update_successfully');

            $this->notify(['type' => 'success', 'message' => $message]);
            $this->dispatch('pg:eventRefresh-bot-flow-table-5ua50n-table');
        } else {
            $this->showSourceModal = false;
        }
    }

    public function confirmDelete($sourceId)
    {
        $this->botFlowId          = $sourceId;
        $this->confirmingDeletion = true;
    }

    public function delete()
    {
        $botFlow = BotFlow::find($this->botFlowId);

        if ($botFlow) {
            $botFlow->delete();
        }

        $this->confirmingDeletion = false;
        $this->resetForm();
        $this->botFlowId = null;
        $this->resetPage();

        $this->notify(['type' => 'success', 'message' => t('source_delete_successfully')]);
        $this->dispatch('pg:eventRefresh-bot-flow-table-5ua50n-table');

    }

    public function editSource($sourceId)
    {
        $source        = BotFlow::findOrFail($sourceId);
        $this->botFlow = $source;

        $this->resetValidation();
        $this->showSourceModal = true;
    }

    private function resetForm()
    {
        $this->reset();
        $this->resetValidation();
        $this->botFlow = new BotFlow;
    }

    public function render()
    {
        return view('livewire.admin.flow-bot.flow-list');
    }
}
