<?php

namespace App\Livewire\Admin\Table;

use App\Models\BotFlow;
use Illuminate\Database\Eloquent\Builder;
use PowerComponents\LivewirePowerGrid\Button;
use PowerComponents\LivewirePowerGrid\Column;
use PowerComponents\LivewirePowerGrid\Facades\PowerGrid;
use PowerComponents\LivewirePowerGrid\PowerGridComponent;

final class BotFlowTable extends PowerGridComponent
{
    public string $tableName = 'bot-flow-table-5ua50n-table';

    public function setUp(): array
    {
        return [
            PowerGrid::header()
                ->showSearchInput(),
            PowerGrid::footer()
                ->showPerPage()
                ->showRecordCount(),
        ];
    }

    public function datasource(): Builder
    {
        return BotFlow::query();
    }

    public function relationSearch(): array
    {
        return [];
    }

    public function columns(): array
    {
        return [
            Column::make(t('ids'), 'id'),
            Column::make(t('name'), 'name')
                ->sortable()
                ->searchable(),

            Column::make(t('description'), 'description')
                ->sortable()
                ->searchable()
                ->bodyAttribute('truncate text-wrap max-w-[400px]'),

            Column::make(t('is_active'), 'is_active')
                ->sortable()
                ->toggleable(hasPermission: true, trueLabel: t('public'))
                ->searchable()
                ->bodyAttribute('flex align-center mt-2'),

            Column::action(t('action')),
        ];
    }

    public function actions(BotFlow $row): array
    {
        return [
            Button::add('flow')
                ->slot(t('flow'))
                ->id()
                ->class('inline-flex items-center gap-2 px-3 py-1 text-sm font-medium text-white bg-success-600 rounded shadow-sm hover:bg-success-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-success-600 justify-center')
                ->route('admin.bot-flows.edit', ['id' => $row->id]),

            Button::add('edit')
                ->slot(t('edit'))
                ->id()
                ->class('inline-flex items-center gap-2 px-3 py-1 text-sm font-medium text-white bg-primary-600 rounded shadow-sm hover:bg-primary-500 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-600 justify-center')
                ->dispatch('editSource', ['sourceId' => $row->id]),

            Button::add('delete')
                ->slot(t('delete'))
                ->id()
                ->class('inline-flex items-center gap-2 px-3 py-1 text-sm font-medium text-white bg-danger-600 rounded shadow-sm hover:bg-danger-500 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-danger-600 justify-center')
                ->dispatch('confirmDelete', ['sourceId' => $row->id]),
        ];
    }

    public function onUpdatedToggleable(string $id, string $field, string $value): void
    {
        $botflow = BotFlow::find($id);
        if ($botflow) {
            $botflow->is_active = ($value === '1') ? 1 : 0;
            $botflow->save();

            $statusMessage = $botflow->is_active
                ? t('bot_flow_activate')
                : t('bot_flow_deactivate');

            $this->notify([
                'message' => $statusMessage,
                'type'    => 'success',
            ]);
        }
    }
}
