<?php

use App\Console\Commands\FileCleanupCommand;
use App\Http\Middleware\CheckDatabaseVersion;
use App\Http\Middleware\SetLocale;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Support\Facades\Route;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
        then: function () {
            // Load admin routes
            Route::middleware(['web', 'validate'])
                ->prefix('admin')
                ->as('admin.')
                ->group([
                    __DIR__ . '/../routes/admin.php',
                    __DIR__ . '/../routes/system-settings.php',
                    __DIR__ . '/../routes/whatsmark-settings.php',
                ]);

            // Load utility routes
            Route::middleware('web')
                ->group(base_path('routes/utilities.php'));

            // Load API routes with api middleware
            Route::middleware(['api'])
                ->prefix('api')
                ->as('api.')
                ->group(function () {
                    Route::middleware(['api.token'])->group(base_path('routes/api.php'));
                    Route::group([], base_path('routes/bot-flow.php'));
                });
        },
    )
    ->withCommands([
        FileCleanupCommand::class,
        // Add more commands here if needed
    ])
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->append(SetLocale::class);
        $middleware->append(CheckDatabaseVersion::class);
        $middleware->alias([
            'api.token' => \App\Http\Middleware\ValidateApiToken::class,
            'validate'  => \Corbital\Installer\Http\Middleware\ValidateBackendRequest::class,
        ]);
        // exclude all webhook urls
        $middleware->validateCsrfTokens([
            'whatsapp/webhook', // Exclude this route from CSRF verification
            'admin/send-message',
            'api/v1/save-bot-flow',
        ]);
        $middleware->append(\Corbital\Installer\Http\Middleware\RedirectIfNotInstalled::class);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
