@extends('layouts.app')

@section('title', t('create_flow'))

@section('content')
<div class="px-6 mx-auto">
    <div class="flex items-center justify-between my-6">
        <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200">
            {{ t('Create Bot Flow') }}
        </h2>
        <a href="{{ route('admin.bot-flows.list') }}" class="flex items-center text-info-600 hover:text-info-800">
            <x-heroicon-o-arrow-left class="w-4 h-4 mr-1" />
            <span>{{ t('Back to Bot Flows') }}</span>
        </a>
    </div>

    <div class="gap-6 mb-6 lg:grid-cols-3">
        <!-- Main content - Bot flow editor -->
        <div class="lg:col-span-2">
            <div class="w-full overflow-hidden rounded-lg shadow-sm bg-white dark:bg-gray-800">
                <div class="w-full">
                    <div id="bot-flow-builder" class="w-full">
                        <bot-flow-builder></bot-flow-builder>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
            // Get the flow builder Vue component instance
            const flowBuilder = document.querySelector('#bot-flow-builder').__vue__;

            // Listen for save button click
            document.getElementById('save-flow-btn').addEventListener('click', function() {
                // Update the flow name and description from the form inputs
                flowBuilder.flowName = document.getElementById('flow_name').value;
                flowBuilder.flowDescription = document.getElementById('flow_description').value;
                flowBuilder.isActive = document.getElementById('is_active').checked;

                // Call the saveFlow method
                flowBuilder.saveFlow();
            });

            // Listen for updates from the Vue component
            window.addEventListener('flow:saved', function(event) {
                if (event.detail && event.detail.success) {
                    // Flash a success message
                    window.dispatchEvent(new CustomEvent('notify', {
                        detail: {
                            message: 'Flow saved successfully!',
                            type: 'success'
                        }
                    }));
                }
            });
        });
</script>
@endpush