<?php

/*
Project         :   WhatsApp Marketing & Automation Platform with Bots, Chats, Bulk Sender & AI
@package        :   Laravel
Laravel Version :   11.41.3
PHP Version     :   8.2.18
Created Date    :   14-01-2025
Copyright       :   Corbital Technologies LLP
Author          :   CORBITALTECH™
Author URL      :   https://codecanyon.net/user/corbitaltech
Support         :   contact@corbitaltech.dev
License         :   Licensed under Codecanyon Licence
*/

use App\Http\Controllers\Admin\ModuleManagerController;
use App\Http\Controllers\BotFlowController;
use App\Http\Controllers\WhatsApp\ChatController;
use App\Http\Controllers\WhatsApp\ManageCampaign;
use App\Http\Controllers\WhatsApp\WhatsAppWebhookController;
use App\Http\Middleware\AdminMiddleware;
use App\Http\Middleware\SanitizeInputs;
use App\Livewire\Admin\Bot\MessageBotCreator;
use App\Livewire\Admin\Bot\MessageBotList;
use App\Livewire\Admin\Bot\TemplateBotCreator;
use App\Livewire\Admin\Bot\TemplateBotList;
use App\Livewire\Admin\Campaign\CampaignCreator;
use App\Livewire\Admin\Campaign\CampaignDetails;
use App\Livewire\Admin\Campaign\CampaignList;
use App\Livewire\Admin\Campaign\CsvCampaign;
use App\Livewire\Admin\Chat\ManageAiPrompt;
use App\Livewire\Admin\Chat\ManageCannedReply;
use App\Livewire\Admin\Contact\ContactCreator;
use App\Livewire\Admin\Contact\ContactList;
use App\Livewire\Admin\Contact\ImportContact;
use App\Livewire\Admin\Contact\ManageSource;
use App\Livewire\Admin\Contact\ManageStatus;
use App\Livewire\Admin\Dashboard;
use App\Livewire\Admin\FlowBot\FlowList;
use App\Livewire\Admin\Miscellaneous\ActivityLogDetails;
use App\Livewire\Admin\Miscellaneous\ActivityLogList;
use App\Livewire\Admin\Miscellaneous\EmailTemplateList;
use App\Livewire\Admin\Miscellaneous\EmailTemplateSave;
use App\Livewire\Admin\Miscellaneous\RoleCreator;
use App\Livewire\Admin\Miscellaneous\RoleList;
use App\Livewire\Admin\Profile\ProfileManager;
use App\Livewire\Admin\Settings\Language\LanguageManager;
use App\Livewire\Admin\Settings\Language\TranslationManager;
use App\Livewire\Admin\Template\TemplateList;
use App\Livewire\Admin\User\UserCreator;
use App\Livewire\Admin\User\UserDetails;
use App\Livewire\Admin\User\UserList;
use App\Livewire\Admin\Waba\ConnectWaba;
use App\Livewire\Admin\Waba\DisconnectWaba;
use Illuminate\Auth\Middleware\EnsureEmailIsVerified;
use Illuminate\Support\Facades\Route;

Route::middleware(['auth', AdminMiddleware::class, EnsureEmailIsVerified::class])

    ->group(function () {

        Route::middleware(SanitizeInputs::class)->group(function () {
            // Dashboard
            Route::get('/', Dashboard::class)->name('dashboard');

            // Contacts
            Route::get('contacts', ContactList::class)->name('contacts.list');
            Route::get('contacts/contact/{contactId?}', ContactCreator::class)->name('contacts.save');
            Route::get('status', ManageStatus::class)->name('status');
            Route::get('source', ManageSource::class)->name('source');
            Route::get('importcontact', ImportContact::class)->name('contacts.imports');

            // WhatsApp API
            Route::get('connect', ConnectWaba::class)->name('connect');
            Route::get('waba', DisconnectWaba::class)->name('waba');

            // Templates & Bots
            Route::get('template', TemplateList::class)->name('template.list');
            Route::get('message-bot', MessageBotList::class)->name('messagebot.list');
            Route::get('message-bot/bot/{messagebotId?}', MessageBotCreator::class)->name('messagebot.create');
            Route::get('template-bot', TemplateBotList::class)->name('templatebot.list');
            Route::get('template-bot/bot/{templatebotId?}', TemplateBotCreator::class)->name('templatebot.create');

            // Campaigns
            Route::get('campaigns', CampaignList::class)->name('campaigns.list');
            Route::get('campaigns/campaign/{campaignId?}', CampaignCreator::class)->name('campaigns.save');
            Route::get('campaigns/campaign/details/{campaignId?}', CampaignDetails::class)->name('campaigns.details');
            Route::get('csvcampaign', CsvCampaign::class)->name('csvcampaign');

            // Chat
            Route::get('ai-prompt', ManageAiPrompt::class)->name('ai-prompt');
            Route::get('canned-reply', ManageCannedReply::class)->name('canned-reply');
            Route::get('chat', [ChatController::class, 'index'])->name('chat');
            Route::get('chat_messages/{chatId?}/{lastMessageId?}', [ChatController::class, 'messagesGet'])->name('chat_messages');
            Route::post('remove-message/{messageId?}', [ChatController::class, 'removeMessage'])->name('remove_message');
            Route::post('remove-chat/{chatId?}', [ChatController::class, 'removeChat'])->name('remove_chat');
            Route::post('assign-agent/{chatId?}', [ChatController::class, 'assignSupportAgent'])->name('assign-agent');
            Route::get('assign-agent-layout/{chatId?}', [ChatController::class, 'getSupportAgentView'])->name('assign-agent-layout');
            Route::post('ai-response', [ChatController::class, 'processAiResponse'])->name('ai_response');
            Route::post('user-information', [ChatController::class, 'userInformation'])->name('user_information');
            Route::post('load-mergefields/{chatType}', [ChatController::class, 'loadMergeFields'])->name('load_mergefields');

            // Miscellaneous
            Route::get('activity-log', ActivityLogList::class)->name('activity-log.list');
            Route::get('activity-log/{logId?}', ActivityLogDetails::class)->name('activity-log.details');
            Route::get('roles', RoleList::class)->name('roles.list');
            Route::get('roles/role/{roleId?}', RoleCreator::class)->name('roles.save');

            // Users & Profile
            Route::get('users', UserList::class)->name('users.list');
            Route::get('users/user/{userId?}', UserCreator::class)->name('users.save');
            Route::get('users/{userId?}', UserDetails::class)->name('users.details');
            Route::get('/profile', ProfileManager::class)->name('profile.edit');

            // Language
            Route::get('/languages', LanguageManager::class)->name('languages');
            Route::get('/languages/{code}/translations', TranslationManager::class)->name('languages.translations');

            // Marketing
            Route::get('/flow-list', FlowList::class)->name('flow_list');

            // Email Templates
            Route::get('emails', EmailTemplateList::class)->name('emails');
            Route::get('emails/{id?}', EmailTemplateSave::class)->name('emails.save');

            // Modules Management
            Route::prefix('modules')->group(function () {
                Route::get('/', [ModuleManagerController::class, 'index'])->name('modules.index');
                Route::post('upload', [ModuleManagerController::class, 'upload'])->name('modules.upload');
                Route::get('{module}/install', [ModuleManagerController::class, 'install'])->name('modules.install');
                Route::get('{module}/toggle', [ModuleManagerController::class, 'toggle'])->name('modules.toggle');
                Route::get('{module}/delete', [ModuleManagerController::class, 'delete'])->name('modules.delete');
            });
            Route::get('/ajax/chart-data', function () {
                $timeRange = request()->get('timeRange', 'today');

                // Create a new instance of the Dashboard component
                $dashboard = new \App\Livewire\Admin\Dashboard;

                // Set the time range and load the data
                $dashboard->timeRange = $timeRange;
                $dashboard->loadMessageStats();

                // Return the chart data as JSON
                return response()->json($dashboard->chartData);
            })->name('admin.ajax.chart-data');

            Route::get('bot-flows', [BotFlowController::class, 'index'])->name('bot-flows.list');
            Route::get('bot-flows/create', [BotFlowController::class, 'create'])->name('bot-flows.create');
            Route::get('bot-flows/edit/{id}', [BotFlowController::class, 'edit'])->name('bot-flows.edit');
            Route::post('bot-flows/save', [BotFlowController::class, 'saveBotFlow'])->name('bot-flows.save');

            Route::post('initiate_chat/{chatId?}', [ChatController::class, 'save'])->name('initiate_chat');
            Route::get('chat_data/{lastChatId?}', [ChatController::class, 'getChats'])->name('chats');

            // Main CRUD Routes

            Route::get('/create', [ManageCampaign::class, 'create'])->name('create');
            Route::post('campaign/store', [ManageCampaign::class, 'store'])->name('store');
            Route::get('/{id}/edit', [ManageCampaign::class, 'edit'])->name('edit');
            Route::put('/{id}', [ManageCampaign::class, 'update'])->name('update');
            Route::delete('/{id}', [ManageCampaign::class, 'destroy'])->name('destroy');

            // manage campaign
            Route::get('campaign', [ManageCampaign::class, 'index'])->name('campaign');
            Route::post('/campaign/ajax/contacts', [ManageCampaign::class, 'getContacts'])->name('campaign.contacts');
            Route::post('/campaign/ajax/count-contacts', [ManageCampaign::class, 'countContacts'])->name('campaign.contacts-counts');
            Route::post('/campaign/ajax/template', [ManageCampaign::class, 'getTemplate'])->name('campaign.template');
            Route::get('/create', [ManageCampaign::class, 'create'])->name('create');
            Route::post('campaign/store', [ManageCampaign::class, 'store'])->name('store');
            Route::get('campaign/edit/{campaign}', [ManageCampaign::class, 'edit'])->name('campaign.edit');
            Route::put('campaign/{campaign}', [ManageCampaign::class, 'update'])->name('campaign.update');
            Route::delete('campaign/delete/{campaign}', [ManageCampaign::class, 'destroy'])->name('campaign.destroy');
        });

        // route without senitize inputes
        Route::post('send-message', [WhatsAppWebhookController::class, 'send_message'])->name('send_message');
    });

require __DIR__ . '/modules.php';
