import defaultTheme from "tailwindcss/defaultTheme";
import forms from "@tailwindcss/forms";

// Add this function for color variants
function generateColorVariant(colorName) {
  return {
    50: `rgb(var(--color-${colorName}-50))`,
    100: `rgb(var(--color-${colorName}-100))`,
    200: `rgb(var(--color-${colorName}-200))`,
    300: `rgb(var(--color-${colorName}-300))`,
    400: `rgb(var(--color-${colorName}-400))`,
    500: `rgb(var(--color-${colorName}-500))`,
    600: `rgb(var(--color-${colorName}-600))`,
    700: `rgb(var(--color-${colorName}-700))`,
    800: `rgb(var(--color-${colorName}-800))`,
    900: `rgb(var(--color-${colorName}-900))`,
  }
}

/** @type {import('tailwindcss').Config} */
export default {
    darkMode: "class",
    content: [
        "./vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php",
        "./storage/framework/views/*.php",
        "./resources/**/*.blade.php",
        "./resources/**/*.js",
        "./resources/**/*.vue",
        "./app/Livewire/**/*Table.php",
        "./vendor/power-components/livewire-powergrid/resources/views/**/*.php",
        "./vendor/power-components/livewire-powergrid/src/Themes/Tailwind.php",
        "./resources/views/**/*.blade.php",
    ],
    safelist: [
        'backdrop-blur-sm',
        'backdrop-blur',
        'backdrop-blur-md',
        'backdrop-blur-lg',
        'backdrop-blur-xl',
        'backdrop-blur-2xl',
        'backdrop-blur-3xl',
        'bg-black/30'
    ],
    presets: [
        require("./vendor/power-components/livewire-powergrid/tailwind.config.js"),
    ],

    theme: {
        extend: {
            animation: {
                'slow-ping': 'ping 2s linear infinite', // Slows down the default ping
            },
            screens: {
                xs: { max: "360px" },
                xss:{min:"400px"}  // Custom media query for 360px
            },
            fontFamily: {
                sans: ["Inter", ...defaultTheme.fontFamily.sans],
                display: ["Lexend", ...defaultTheme.fontFamily.sans],
            },
            colors: {
                // Standard Tailwind color palettes
                slate: generateColorVariant('slate'),
                gray: generateColorVariant('gray'),
                zinc: generateColorVariant('zinc'),
                neutral: generateColorVariant('neutral'),
                stone: generateColorVariant('stone'),
                red: generateColorVariant('red'),
                orange: generateColorVariant('orange'),
                amber: generateColorVariant('amber'),
                yellow: generateColorVariant('yellow'),
                lime: generateColorVariant('lime'),
                green: generateColorVariant('green'),
                emerald: generateColorVariant('emerald'),
                teal: generateColorVariant('teal'),
                cyan: generateColorVariant('cyan'),
                sky: generateColorVariant('sky'),
                blue: generateColorVariant('blue'),
                indigo: generateColorVariant('indigo'),
                violet: generateColorVariant('violet'),
                purple: generateColorVariant('purple'),
                fuchsia: generateColorVariant('fuchsia'),
                pink: generateColorVariant('pink'),
                rose: generateColorVariant('rose'),

                // Semantic color mappings (these use the CSS variables that reference the standard colors)
                primary: generateColorVariant('primary'),
                secondary: generateColorVariant('secondary'),
                danger: generateColorVariant('danger'),
                warning: generateColorVariant('warning'),
                success: generateColorVariant('success'),
                info: generateColorVariant('info'),
            },
        },
    },
    plugins: [
        forms,
        require("@tailwindcss/typography"),
        require("@tailwindcss/aspect-ratio"),
    ],
};
