<x-app-layout>

    <div class="py-6">
        <div class="mx-auto max-w-7xl sm:px-6 lg:px-8">
            <div class="overflow-hidden bg-white shadow-sm dark:bg-gray-800 sm:rounded-lg">
                {{-- back-to-module link --}}
                <div class="border-b border-gray-200 bg-gray-50/80 px-6 py-4 dark:border-gray-700 dark:bg-gray-800/60">
                    <div class="flex items-center space-x-2">
                        <a href="{{ route('admin.modules.index') }}"
                            class="flex items-center text-sm font-medium text-gray-600 transition-colors dark:text-gray-400 hover:text-primary-600 dark:hover:text-primary-400">
                            <svg xmlns="http://www.w3.org/2000/svg" class="mr-1 h-4 w-4" viewBox="0 0 20 20"
                                fill="currentColor">
                                <path fill-rule="evenodd"
                                    d="M9.707 14.707a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 1.414L7.414 9H15a1 1 0 110 2H7.414l2.293 2.293a1 1 0 010 1.414z"
                                    clip-rule="evenodd" />
                            </svg>
                            {{ __('Back to Module Manager') }}
                        </a>
                    </div>
                </div>
                <!-- Module Header Section -->
                <div class="border-b border-gray-200 dark:border-gray-700">
                    <div class="px-3 py-4 sm:px-6 sm:py-6 md:flex md:items-center md:justify-between">
                        <div class="flex flex-col sm:flex-row sm:items-center gap-x-5">
                            <!-- Module Icon/Logo with modern design -->
                            <div
                                class="mb-4 mr-0 flex h-12 w-12 sm:h-14 sm:w-14 md:h-16 md:w-16 sm:mb-0 sm:mr-4 md:mr-5 items-center justify-center overflow-hidden rounded-lg bg-gradient-to-br from-primary-600 to-purple-600 text-white shadow-lg">
                                <span class="text-xl sm:text-2xl font-bold">{{ substr($module['name'], 0, 1) }}</span>
                            </div>

                            <div class="flex-1">
                                <h1
                                    class="flex flex-wrap items-center gap-x-2 text-xl sm:text-2xl font-bold text-gray-900 dark:text-white">
                                    {{ $module['name'] }}
                                    <span x-data="{}"
                                        x-tooltip="'{{ $module['info']['type'] === 'core' ? 'Core modules cannot be deactivated or removed' : 'Addon modules can be deactivated and removed' }}'"
                                        class="mt-1 sm:mt-0 sm:ml-2 inline-flex items-center rounded-full px-2.5 py-0.5 text-xs font-medium {{ $module['info']['type'] === 'core' ? 'bg-info-100 text-info-800 dark:bg-info-800/30 dark:text-info-200' : 'bg-purple-100 text-purple-800 dark:bg-purple-800/30 dark:text-purple-200' }}">
                                        {{ ucfirst($module['info']['type'] ?? 'addon') }}
                                    </span>
                                </h1>
                                <p
                                    class="mt-1 text-sm text-gray-500 dark:text-gray-400 line-clamp-2 sm:line-clamp-none">
                                    {{ $module['info']['description'] ?? 'No description available' }}
                                </p>
                                <div class="mt-2 sm:mt-3 flex flex-wrap gap-x-3 sm:gap-x-4 gap-y-2">
                                    <div class="text-xs sm:text-sm text-gray-500 dark:text-gray-400">
                                        <span class="font-medium text-gray-700 dark:text-gray-300">Version:</span>
                                        <span class="ml-1 bg-gray-100 dark:bg-gray-700 px-2 py-0.5 rounded text-xs">
                                            {{ $module['info']['version'] ?? '1.0.0' }}
                                        </span>
                                    </div>
                                    <div class="text-xs sm:text-sm text-gray-500 dark:text-gray-400">
                                        <span class="font-medium text-gray-700 dark:text-gray-300">Author:</span>
                                        {{ $module['info']['author'] ?? 'Unknown' }}
                                    </div>
                                    @if (isset($module['info']['url']) && $module['info']['url'])
                                    <div class="text-xs sm:text-sm text-gray-500 dark:text-gray-400">
                                        <span class="font-medium text-gray-700 dark:text-gray-300">Website:</span>
                                        <a href="{{ $module['info']['url'] }}" target="_blank"
                                            class="ml-1 text-primary-600 hover:text-primary-500 dark:text-primary-400 dark:hover:text-primary-300">
                                            Visit website
                                            <svg xmlns="http://www.w3.org/2000/svg" class="ml-1 inline h-3 w-3"
                                                viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd"
                                                    d="M10.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L12.586 11H5a1 1 0 110-2h7.586l-2.293-2.293a1 1 0 010-1.414z"
                                                    clip-rule="evenodd" />
                                            </svg>
                                        </a>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- Status & Actions -->
                        <div class="mt-5 w-full md:w-auto">
                            <!-- Module Status with improved visual styling -->
                            <div x-data="{ status: '{{ $module['active'] ? 'active' : 'inactive' }}' }"
                                class="flex items-start gap-3 sm:items-center sm:flex-row">
                                <div class="flex items-center gap-2 rounded-md px-3 py-2 text-sm font-medium shadow-sm sm:w-auto"
                                    :class="status === 'active' ?
                                        'text-success-800 bg-success-100 dark:bg-success-800/20 dark:text-success-300 border border-success-200 dark:border-success-800/40' :
                                        'text-warning-800 bg-warning-100 dark:bg-warning-800/20 dark:text-warning-300 border border-warning-200 dark:border-warning-800/40'">
                                    <span x-show="status === 'active'" class="relative flex h-3 w-3">
                                        <span
                                            class="absolute inline-flex h-full w-full animate-ping rounded-full bg-success-400 opacity-75 dark:bg-success-600"></span>
                                        <span
                                            class="relative inline-flex h-3 w-3 rounded-full bg-success-500 dark:bg-success-500"></span>
                                    </span>
                                    <span x-show="status === 'inactive'"
                                        class="h-3 w-3 rounded-full bg-warning-400 dark:bg-warning-600"></span>
                                    <span x-text="status === 'active' ? 'Active' : 'Inactive'"></span>
                                </div>

                                @if ($module['info']['type'] === 'core')
                                <!-- Core Module Badge with updated styling -->
                                <div
                                    class="inline-flex items-center rounded-md border border-info-200 bg-info-100 px-3 py-2 text-sm font-medium text-info-800 shadow-sm dark:border-info-800/40 dark:bg-info-800/20 dark:text-info-300">
                                    <svg class=" mr-1 inline-block h-4 w-4" xmlns="http://www.w3.org/2000/svg"
                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    Core Module
                                </div>
                                @else
                                <!-- Action Buttons with consistent styling -->
                                <div class="flex flex-wrap gap-2 w-full sm:w-auto">
                                    @if ($module['active'])
                                    <form action="{{ route('admin.modules.deactivate', $module['name']) }}"
                                        method="POST" class="w-full sm:w-auto">
                                        @csrf
                                        <button type="submit" x-on:click="status = 'inactive'"
                                            class="w-full sm:w-auto inline-flex items-center justify-center rounded-md border border-warning-300 bg-warning-100 px-3 sm:px-4 py-2 text-sm font-medium text-warning-800 transition-colors hover:bg-warning-200 focus:outline-none focus:ring-2 focus:ring-warning-500 focus:ring-offset-2 dark:border-warning-800/40 dark:bg-warning-900/20 dark:text-warning-300 dark:hover:bg-warning-900/30 dark:focus:ring-offset-gray-800">
                                            <svg class="-ml-1 mr-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636" />
                                            </svg>
                                            Deactivate
                                        </button>
                                    </form>
                                    @else
                                    <form action="{{ route('admin.modules.activate', $module['name']) }}" method="POST"
                                        class="w-full sm:w-auto">
                                        @csrf
                                        <button type="submit" x-on:click="status = 'active'"
                                            class="sm:w-auto inline-flex items-center justify-center rounded-md border border-success-300 bg-success-100 px-3 sm:px-4 py-2 text-sm font-medium text-success-800 transition-colors hover:bg-success-200 focus:outline-none focus:ring-2 focus:ring-success-500 focus:ring-offset-2 dark:border-success-800/40 dark:bg-success-900/20 dark:text-success-300 dark:hover:bg-success-900/30 dark:focus:ring-offset-gray-800">
                                            <svg class="-ml-1 mr-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M5 13l4 4L19 7" />
                                            </svg>
                                            Activate
                                        </button>
                                    </form>
                                    @endif

                                    <form x-data="{ showConfirm: false }"
                                        action="{{ route('admin.modules.remove', $module['name']) }}" method="POST"
                                        x-on:submit.prevent="showConfirm = true" class="w-full sm:w-auto">
                                        @csrf
                                        @method('DELETE')

                                        <button type="submit"
                                            class="w-full sm:w-auto inline-flex items-center justify-center rounded-md border border-danger-300 bg-danger-100 px-3 sm:px-4 py-2 text-sm font-medium text-danger-800 transition-colors hover:bg-danger-200 focus:outline-none focus:ring-2 focus:ring-danger-500 focus:ring-offset-2 dark:border-danger-800/40 dark:bg-danger-900/20 dark:text-danger-300 dark:hover:bg-danger-900/30 dark:focus:ring-offset-gray-800">
                                            <svg class="-ml-1 mr-2 h-4 w-4" xmlns="http://www.w3.org/2000/svg"
                                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                            </svg>
                                            Remove
                                        </button>

                                        <!-- Modern Confirmation Dialog -->
                                        <div x-show="showConfirm" x-cloak
                                            class="fixed inset-0 z-50 flex items-center justify-center overflow-auto bg-black bg-opacity-50 backdrop-blur-sm p-4">
                                            <div class="mx-auto w-full max-w-md overflow-hidden rounded-lg border border-gray-200 bg-white p-4 sm:p-6 shadow-xl dark:border-gray-700 dark:bg-gray-800"
                                                @click.away="showConfirm = false">
                                                <div
                                                    class="mb-4 flex items-center text-danger-600 dark:text-danger-400">
                                                    <svg class="mr-2 h-6 w-6" xmlns="http://www.w3.org/2000/svg"
                                                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2"
                                                            d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                                                    </svg>
                                                    <h3 class="text-lg font-medium">Confirm Removal</h3>
                                                </div>
                                                <p class="mb-6 text-sm text-gray-600 dark:text-gray-300">
                                                    Are you sure you want to remove the <span class="font-semibold">{{
                                                        $module['name'] }}</span> module? This action cannot be undone
                                                    and may affect functionality.
                                                </p>
                                                <div
                                                    class="flex flex-col sm:flex-row sm:justify-end space-y-3 sm:space-y-0 sm:space-x-3">
                                                    <button type="button" @click="showConfirm = false"
                                                        class="w-full sm:w-auto rounded-md border border-gray-300 bg-white px-4 py-2 text-sm font-medium text-gray-700 shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-primary-500 focus:ring-offset-2 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 dark:hover:bg-gray-600 dark:focus:ring-offset-gray-800">
                                                        Cancel
                                                    </button>
                                                    <button type="button"
                                                        @click="$event.target.closest('form').submit()"
                                                        class="w-full sm:w-auto rounded-md bg-danger-600 px-4 py-2 text-sm font-medium text-white shadow-sm transition-colors hover:bg-danger-700 focus:outline-none focus:ring-2 focus:ring-danger-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800">
                                                        Confirm Remove
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Core Module Message with improved alert styling -->
                @if ($module['info']['type'] === 'core')
                <div
                    class="mx-6 mt-6 flex items-center rounded-lg border border-info-300 bg-info-50 px-4 py-3 dark:border-info-800 dark:bg-info-900/20">
                    <div class="mr-3 flex-shrink-0">
                        <svg class="h-5 w-5 text-info-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                            fill="currentColor">
                            <path fill-rule="evenodd"
                                d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"
                                clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div>
                        <p class="text-sm text-info-800 dark:text-info-300">
                            <strong>This is a core module and cannot be deactivated or removed.</strong> Core
                            modules provide essential functionality for the application.
                        </p>
                    </div>
                </div>
                @endif

                <!-- Module Details with modern tab design -->
                <div x-data="{ activeTab: 'info' }" class="p-6">
                    <div class="mb-6 flex items-center border-b border-gray-200 dark:border-gray-700">
                        <button @click="activeTab = 'info'"
                            :class="activeTab === 'info' ?
                                'border-primary-500 text-primary-600 dark:border-primary-400 dark:text-primary-400' :
                                'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300 dark:hover:border-gray-600'"
                            class="inline-flex items-center border-b-2 py-4 px-1 text-sm font-medium">
                            <svg xmlns="http://www.w3.org/2000/svg" class="-ml-0.5 mr-2 h-4 w-4" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            Information
                        </button>
                        <button @click="activeTab = 'dependencies'"
                            :class="activeTab === 'dependencies' ?
                                'border-primary-500 text-primary-600 dark:border-primary-400 dark:text-primary-400' :
                                'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300 dark:hover:border-gray-600'"
                            class="ml-8 inline-flex items-center border-b-2 py-4 px-1 text-sm font-medium">
                            <svg xmlns="http://www.w3.org/2000/svg" class="-ml-0.5 mr-2 h-4 w-4" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M9 19l3 3m0 0l3-3m-3 3V10" />
                            </svg>
                            Dependencies & Conflicts
                        </button>
                    </div>

                    <!-- Info Tab with improved card layout -->
                    <div x-show="activeTab === 'info'" x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" class="mt-6">
                        <div class="overflow-hidden rounded-lg border border-gray-200 dark:border-gray-700">
                            <div
                                class="border-b border-gray-200 bg-gray-50 px-4 py-3 dark:border-gray-700 dark:bg-gray-800/60">
                                <h3 class="text-sm font-medium text-gray-900 dark:text-white">Module Information</h3>
                            </div>
                            <div class="bg-white p-4 dark:bg-gray-800">
                                <dl class="space-y-5 divide-y divide-gray-200 dark:divide-gray-700">
                                    <div class="grid grid-cols-1 gap-4 pt-3 sm:grid-cols-2">
                                        <div>
                                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Module Name
                                            </dt>
                                            <dd class="mt-1 text-sm font-medium text-gray-900 dark:text-white">{{
                                                $module['name'] }}</dd>
                                        </div>
                                        <div>
                                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Version
                                            </dt>
                                            <dd class="mt-1 text-sm font-medium text-gray-900 dark:text-white">
                                                {{ $module['info']['version'] ?? '1.0.0' }}
                                            </dd>
                                        </div>
                                    </div>

                                    <div class="grid grid-cols-1 gap-4 pt-4 sm:grid-cols-2">
                                        <div>
                                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Author</dt>
                                            <dd class="mt-1 text-sm font-medium text-gray-900 dark:text-white">
                                                {{ $module['info']['author'] ?? 'Unknown' }}
                                            </dd>
                                        </div>
                                        <div>
                                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Type</dt>
                                            <dd class="mt-1 text-sm font-medium text-gray-900 dark:text-white">
                                                {{ ucfirst($module['info']['type'] ?? 'addon') }}
                                            </dd>
                                        </div>
                                    </div>

                                    <div class="pt-4">
                                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Description
                                        </dt>
                                        <dd class="mt-1 text-sm text-gray-900 dark:text-white">
                                            {{ $module['info']['description'] ?? 'No description available' }}
                                        </dd>
                                    </div>

                                    <div class="pt-4">
                                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Path</dt>
                                        <dd
                                            class="mt-1 overflow-auto rounded-md bg-gray-50 p-2 text-sm font-mono text-gray-900 dark:bg-gray-700/50 dark:text-gray-200">
                                            {{ $module['path'] }}
                                        </dd>
                                    </div>
                                </dl>
                            </div>
                        </div>
                    </div>

                    <!-- Dependencies & Conflicts Tab with improved list design -->
                    <div x-show="activeTab === 'dependencies'" x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" class="mt-6">
                        <div class="grid grid-cols-1 gap-6 lg:grid-cols-2">
                            <!-- Dependencies Card -->
                            <div class="overflow-hidden rounded-lg border border-gray-200 dark:border-gray-700">
                                <div
                                    class="border-b border-gray-200 bg-gray-50 px-4 py-3 dark:border-gray-700 dark:bg-gray-800/60">
                                    <div class="flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="mr-2 h-4 w-4 text-info-500"
                                            fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" />
                                        </svg>
                                        <h3 class="text-sm font-medium text-gray-900 dark:text-white">Required Modules
                                        </h3>
                                    </div>
                                </div>
                                <div class="bg-white p-4 dark:bg-gray-800">
                                    @if (!empty($module['info']['require']))
                                    <ul class="space-y-3">
                                        @foreach ($module['info']['require'] as $dependency => $version)
                                        <li
                                            class="flex items-center rounded-md border {{ ModuleManager::has($dependency) ? (ModuleManager::isActive($dependency) ? 'border-success-200 bg-success-50 dark:border-success-900 dark:bg-success-900/10' : 'border-warning-200 bg-warning-50 dark:border-warning-900 dark:bg-warning-900/10') : 'border-danger-200 bg-danger-50 dark:border-danger-900 dark:bg-danger-900/10' }} p-3">
                                            <div
                                                class="mr-3 flex h-8 w-8 flex-shrink-0 items-center justify-center rounded-full {{ ModuleManager::has($dependency) ? (ModuleManager::isActive($dependency) ? 'bg-success-100 text-success-700 dark:bg-success-800/20 dark:text-success-400' : 'bg-warning-100 text-warning-700 dark:bg-warning-800/20 dark:text-warning-400') : 'bg-danger-100 text-danger-700 dark:bg-danger-800/20 dark:text-danger-400' }}">
                                                @if (ModuleManager::has($dependency))
                                                @if (ModuleManager::isActive($dependency))
                                                <svg class="h-5 w-5" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        stroke-width="2" d="M5 13l4 4L19 7"></path>
                                                </svg>
                                                @else
                                                <svg class="h-5 w-5" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        stroke-width="2"
                                                        d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z">
                                                    </path>
                                                </svg>
                                                @endif
                                                @else
                                                <svg class="h-5 w-5" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                                </svg>
                                                @endif
                                            </div>
                                            <div>
                                                <span
                                                    class="font-medium {{ ModuleManager::has($dependency) ? (ModuleManager::isActive($dependency) ? 'text-success-900 dark:text-success-200' : 'text-warning-900 dark:text-warning-200') : 'text-danger-900 dark:text-danger-200' }}">
                                                    {{ $dependency }}
                                                </span>
                                                <span
                                                    class="ml-2 text-xs {{ ModuleManager::has($dependency) ? (ModuleManager::isActive($dependency) ? 'text-success-600 dark:text-success-400' : 'text-warning-600 dark:text-warning-400') : 'text-danger-600 dark:text-danger-400' }}">
                                                    {{ $version }}
                                                </span>
                                                @if (!ModuleManager::has($dependency))
                                                <div
                                                    class="mt-1 text-xs font-medium text-danger-600 dark:text-danger-400">
                                                    Missing - Module needs to be installed
                                                </div>
                                                @elseif(!ModuleManager::isActive($dependency))
                                                <div
                                                    class="mt-1 text-xs font-medium text-warning-600 dark:text-warning-400">
                                                    Inactive - Module needs to be activated
                                                </div>
                                                @endif
                                            </div>
                                        </li>
                                        @endforeach
                                    </ul>
                                    @else
                                    <div
                                        class="flex items-center justify-center rounded-md bg-gray-50 p-4 dark:bg-gray-700/30">
                                        <p class="text-sm text-gray-500 dark:text-gray-400">
                                            This module has no dependencies.
                                        </p>
                                    </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Conflicts Card -->
                            <div class="overflow-hidden rounded-lg border border-gray-200 dark:border-gray-700">
                                <div
                                    class="border-b border-gray-200 bg-gray-50 px-4 py-3 dark:border-gray-700 dark:bg-gray-800/60">
                                    <div class="flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="mr-2 h-4 w-4 text-danger-500"
                                            fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                                        </svg>
                                        <h3 class="text-sm font-medium text-gray-900 dark:text-white">Conflicts</h3>
                                    </div>
                                </div>
                                <div class="bg-white p-4 dark:bg-gray-800">
                                    @if (!empty($module['info']['conflicts']))
                                    <ul class="space-y-3">
                                        @foreach ($module['info']['conflicts'] as $conflict)
                                        <li
                                            class="flex items-center rounded-md border border-danger-200 bg-danger-50 p-3 dark:border-danger-900 dark:bg-danger-900/10">
                                            <div
                                                class="mr-3 flex h-8 w-8 flex-shrink-0 items-center justify-center rounded-full bg-danger-100 text-danger-700 dark:bg-danger-800/20 dark:text-danger-400">
                                                <svg class="h-5 w-5" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                                </svg>
                                            </div>
                                            <div>
                                                <span class="font-medium text-danger-900 dark:text-danger-200">{{
                                                    $conflict
                                                    }}</span>
                                                <div class="mt-1 text-xs text-danger-600 dark:text-danger-400">
                                                    Cannot be active together with this module
                                                </div>
                                            </div>
                                        </li>
                                        @endforeach
                                    </ul>
                                    @else
                                    <div
                                        class="flex items-center justify-center rounded-md bg-gray-50 p-4 dark:bg-gray-700/30">
                                        <p class="text-sm text-gray-500 dark:text-gray-400">
                                            This module has no conflicts with other modules.
                                        </p>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Styling for Alpine.js -->
    <style>
        [x-cloak] {
            display: none !important;
        }
    </style>
</x-app-layout>