<x-app-layout>
  <div class="py-12">
    <div class="max-w-8xl mx-auto sm:px-6 lg:px-8">
      <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <!-- Header Section -->
        <div class="p-6 border-b border-gray-200">
          <div class="flex justify-between items-center">
            <h2 class="text-2xl font-semibold text-gray-800">Module Manager</h2>
            <div x-data="{ isUploading: false, fileName: '' }">
              <form action="{{ route('admin.modules.upload') }}" method="POST" enctype="multipart/form-data"
                @submit="isUploading = true">
                @csrf
                <div class="flex items-center gap-4">
                  <input type="file" name="module" accept=".zip" class="hidden" id="moduleFile"
                    @change="fileName = $event.target.files[0].name">

                  <label for="moduleFile"
                    class="px-4 py-2 bg-gray-100 rounded cursor-pointer hover:bg-gray-200 flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                    </svg>
                    Upload Module
                  </label>

                  <span x-show="fileName" x-text="fileName" class="text-sm text-gray-600">
                  </span>

                  <button x-show="fileName" type="submit"
                    class="inline-flex items-center px-4 py-2 bg-info-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-info-700 active:bg-info-800 focus:outline-none focus:border-info-800 focus:ring ring-info-300 disabled:opacity-25 transition">
                    <span x-show="!isUploading">Upload Now</span>
                    <span x-show="isUploading" class="flex items-center gap-2">
                      <svg class="animate-spin h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg" fill="none"
                        viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4">
                        </circle>
                        <path class="opacity-75" fill="currentColor"
                          d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z">
                        </path>
                      </svg>
                      Uploading...
                    </span>
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>

        <!-- Modules List -->
        <div class="overflow-x-auto">
          <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
              <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                  Module</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                  Description</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                  Version</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                  Type</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                  Status</th>
                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                  Actions</th>
              </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
              @foreach ($modules as $module)
              <tr class="hover:bg-gray-50">
                <td class="px-6 py-4">
                  <div class="flex items-center">
                    <div>
                      <div class="text-sm font-medium text-gray-900">
                        {{ $module['json']['name'] ?? $module['name'] }}
                      </div>
                      @if (isset($module['json']['alias']))
                      <div class="text-sm text-gray-500">
                        {{ $module['json']['alias'] }}
                      </div>
                      @endif
                    </div>
                  </div>
                </td>
                <td class="px-6 py-4">
                  <div class="text-sm text-gray-900">
                    {{ $module['json']['description'] ?? 'No description available' }}
                  </div>
                  @if (isset($module['json']['help_link']))
                  <a href="{{ $module['json']['help_link'] }}" target="_blank"
                    class="text-xs text-info-600 hover:text-info-800">
                    Documentation →
                  </a>
                  @endif
                </td>
                <td class="px-6 py-4 whitespace-nowrap">
                  <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-info-100 text-info-800">
                    v{{ $module['json']['version'] ?? '1.0.0' }}
                  </span>
                </td>
                <td class="px-6 py-4 whitespace-nowrap">
                  @if ($module['is_core'])
                  <span
                    class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-purple-100 text-purple-800">
                    Core
                  </span>
                  @else
                  <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-800">
                    Addon
                  </span>
                  @endif
                </td>
                <td class="px-6 py-4 whitespace-nowrap">
                  @if ($module['is_enabled'])
                  <span
                    class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-success-100 text-success-800">
                    Active
                  </span>
                  @else
                  <span
                    class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-danger-100 text-danger-800">
                    Inactive
                  </span>
                  @endif
                </td>
                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium" x-data="{ open: false }">
                  <div class="relative">
                    <button @click="open = !open" class="text-gray-500 hover:text-gray-700">
                      <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path
                          d="M6 10a2 2 0 11-4 0 2 2 0 014 0zM12 10a2 2 0 11-4 0 2 2 0 014 0zM16 12a2 2 0 100-4 2 2 0 000 4z" />
                      </svg>
                    </button>

                    <div x-show="open" @click.away="open = false"
                      class="relative right-0 mt-2 w-48 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 divide-y divide-gray-100 z-50">

                      <div class="py-1">
                        @if (!$module['is_enabled'])
                        <a href="{{ route('admin.modules.install', $module['name']) }}"
                          class="group flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                          <svg class="mr-3 h-5 w-5 text-gray-400 group-hover:text-gray-500" viewBox="0 0 20 20"
                            fill="currentColor">
                            <path fill-rule="evenodd"
                              d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-11a1 1 0 10-2 0v2H7a1 1 0 100 2h2v2a1 1 0 102 0v-2h2a1 1 0 100-2h-2V7z"
                              clip-rule="evenodd" />
                          </svg>
                          Install
                        </a>
                        @endif

                        @if (!$module['is_core'])
                        <a href="{{ route('admin.modules.toggle', $module['name']) }}"
                          class="group flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                          <svg class="mr-3 h-5 w-5 text-gray-400 group-hover:text-gray-500" viewBox="0 0 20 20"
                            fill="currentColor">
                            <path fill-rule="evenodd"
                              d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-8.707l-3-3a1 1 0 00-1.414 0l-3 3a1 1 0 001.414 1.414L9 9.414V13a1 1 0 102 0V9.414l1.293 1.293a1 1 0 001.414-1.414z"
                              clip-rule="evenodd" />
                          </svg>
                          {{ $module['is_enabled'] ? 'Disable' : 'Enable' }}
                        </a>

                        @if (!$module['is_enabled'])
                        <a href="{{ route('admin.modules.delete', $module['name']) }}"
                          onclick="return confirm('Are you sure you want to delete this module?')"
                          class="group flex items-center px-4 py-2 text-sm text-danger-700 hover:bg-danger-100">
                          <svg class="mr-3 h-5 w-5 text-danger-400 group-hover:text-danger-500" viewBox="0 0 20 20"
                            fill="currentColor">
                            <path fill-rule="evenodd"
                              d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z"
                              clip-rule="evenodd" />
                          </svg>
                          Delete
                        </a>
                        @endif
                        @endif
                      </div>
                    </div>
                  </div>
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>
        </div>

        <!-- Pagination -->
        <div class="px-6 py-4 border-t border-gray-200">
          {{ $modules->links() }}
        </div>
      </div>
    </div>
  </div>

  <!-- Flash Messages -->
  @if (session('success') || session('error'))
  <div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 5000)"
    class="fixed bottom-4 right-4">
    <div
      class="rounded-lg p-4 {{ session('success') ? 'bg-success-50 text-success-800' : 'bg-danger-50 text-danger-800' }}">
      <div class="flex">
        <div class="flex-shrink-0">
          @if (session('success'))
          <svg class="h-5 w-5 text-success-400" viewBox="0 0 20 20" fill="currentColor">
            <path fill-rule="evenodd"
              d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
              clip-rule="evenodd" />
          </svg>
          @else
          <svg class="h-5 w-5 text-danger-400" viewBox="0 0 20 20" fill="currentColor">
            <path fill-rule="evenodd"
              d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
              clip-rule="evenodd" />
          </svg>
          @endif
        </div>
        <div class="ml-3">
          <p class="text-sm font-medium">
            {{ session('success') ?? session('error') }}
          </p>
        </div>
        <div class="ml-auto pl-3">
          <div class="-mx-1.5 -my-1.5">
            <button @click="show = false"
              class="inline-flex rounded-md p-1.5 focus:outline-none focus:ring-2 focus:ring-offset-2 {{ session('success') ? 'text-success-500 hover:bg-success-100 focus:ring-offset-success-50 focus:ring-success-600' : 'text-danger-500 hover:bg-danger-100 focus:ring-offset-danger-50 focus:ring-danger-600' }}">
              <span class="sr-only">Dismiss</span>
              <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd"
                  d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                  clip-rule="evenodd" />
              </svg>
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
  @endif
</x-app-layout>