@extends('layouts.app')

@section('title', t('create flow'))

@section('content')

<div x-data="{ isOpen: false }" class="p-6">
  <!-- Trigger Button -->
  <x-button.primary x-on:click="isOpen = true">
    <x-heroicon-m-plus class="w-4 h-4 mr-1" />{{ t('bot_flow') }}
  </x-button.primary>

  <x-card class="mx-4 mt-3 lg:mx-0 rounded-lg">
    <x-slot:content>
      <div class="mt-8 lg:mt-0">
        <livewire:admin.table.bot-flow-table />
      </div>
    </x-slot:content>
  </x-card>

  <!-- Modal -->
  <div x-show="isOpen" @click.away="isOpen = false" x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="opacity-0 -translate-y-4" x-transition:enter-end="opacity-100 translate-y-0"
    x-transition:leave="transition ease-in duration-200" x-transition:leave-start="opacity-100 translate-y-0"
    x-transition:leave-end="opacity-0 -translate-y-4" class="fixed inset-x-0 top-6 mx-auto w-full max-w-2xl z-50"
    x-cloak>
    <div class="bg-white rounded-lg shadow-xl ">
      <!-- Modal Header -->
      <div class="flex justify-between items-center border-b p-5">
        <h3 class="text-lg font-semibold text-gray-900">Modal Title</h3>
      </div>

      <!-- Modal Content -->

      <form x-data="formHandler()" @submit.prevent="submitForm">
        @csrf
        <div class="space-y-3 px-6 py-2">
          <div>
            <div class="flex item-centar justify-start gap-1">
              <span class="text-danger-500">*</span>
              <x-label class="dark:text-gray-300 block text-sm font-medium text-gray-700">{{ t('name') }}</x-label>
            </div>
            <x-input x-model="name" name="name" type="text" id="name" class="w-full" />
            <x-input-error for="name" class="mt-2" />
          </div>

          <div>
            <div class="flex item-centar justify-start gap-1">
              <span class="text-danger-500">*</span>
              <x-label for="description" class="dark:text-gray-300 block text-sm font-medium text-gray-700">
                {{ t('description') }}
              </x-label>
            </div>
            <x-textarea x-model="description" name="description" rows="3"></x-textarea>
            <x-input-error for="description" class="mt-2" />
          </div>

        </div>

        <!-- Modal Footer -->
        <div class="py-4 flex justify-end space-x-3 border-t border-neutral-200 dark:border-neutral-500/30  mt-5 px-6">
          <x-button.secondary x-on:click="isOpen = false">
            {{ t('cancel') }}
          </x-button.secondary>
          <x-button.loading-button type="submit">
            {{ t('submit') }}
          </x-button.loading-button>
        </div>

      </form>
    </div>
  </div>

  <!-- Overlay -->
  <div x-show="isOpen" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0"
    x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-200"
    x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
    class="fixed inset-0 bg-black bg-opacity-50 z-40" x-cloak>
  </div>
</div>
@endsection

@push('scripts')
<script>
  async function confirmDelete(id) {
      const confirmed = await showConfirmDialog({
        title: "{{ t('Delete Bot Flow') }}",
        message: "{{ t('Are you sure you want to delete this flow? This action cannot be undone.') }}",
        confirmText: "{{ t('Delete') }}",
        cancelText: "{{ t('Cancel') }}"
      });

      if (confirmed) {
        fetch(`/api/v1/bot-flows/delete/${id}`, {
            method: 'DELETE',
            headers: {
              'Content-Type': 'application/json',
              'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute(
                'content')
            }
          })
          .then(response => response.json())
          .then(data => {
            if (data.success) {
              window.location.reload();
            } else {
              showNotification(data.message || 'An error occurred', 'danger');
            }
          })
          .catch(error => {
            console.error('Error:', error);
            showNotification('Failed to delete flow', 'danger');
          });
      }
    }

    function showNotification(message, type = 'info') {
      window.dispatchEvent(new CustomEvent('notify', {
        detail: {
          message,
          type
        }
      }));
    }

    function formHandler() {
      return {
        name: '',
        description: '',
        async submitForm() {
          let formData = new FormData();
          formData.append('name', this.name);
          formData.append('description', this.description);

          let response = await fetch('bot-flows/save', {
            method: 'POST',
            body: formData,
            headers: {
              'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            }
          });

          let result = await response.json();
          console.log(result);
        }
      }
    }
</script>
@endpush