@props(['type' => 'info', 'message', 'dismissible' => false])

@php
$types = [
    'info' => [
        'bg' => 'bg-info-50 dark:bg-info-900/20',
        'text' => 'text-info-800 dark:text-info-200',
        'border' => 'border-info-300 dark:border-info-800',
        'icon' => 'text-info-500 dark:text-info-400'
    ],
    'success' => [
        'bg' => 'bg-success-50 dark:bg-success-900/20',
        'text' => 'text-success-800 dark:text-success-200',
        'border' => 'border-success-300 dark:border-success-800',
        'icon' => 'text-success-500 dark:text-success-400'
    ],
    'warning' => [
        'bg' => 'bg-warning-50 dark:bg-warning-900/20',
        'text' => 'text-warning-800 dark:text-warning-200',
        'border' => 'border-warning-300 dark:border-warning-800',
        'icon' => 'text-warning-500 dark:text-warning-400'
    ],
    'danger' => [
        'bg' => 'bg-danger-50 dark:bg-danger-900/20',
        'text' => 'text-danger-800 dark:text-danger-200',
        'border' => 'border-danger-300 dark:border-danger-800',
        'icon' => 'text-danger-500 dark:text-danger-400'
    ],
];

$classes = $types[$type] ?? $types['info'];
@endphp

<div class="rounded-md border {{ $classes['bg'] }} {{ $classes['border'] }} p-4 mb-4" x-data="{ show: true }" x-show="show">
    <div class="flex">
        <div class="flex-shrink-0">
            @if($type === 'info')
                <x-heroicon-s-information-circle class="h-5 w-5 {{ $classes['icon'] }}" />
            @elseif($type === 'success')
                <x-heroicon-s-check-circle class="h-5 w-5 {{ $classes['icon'] }}" />
            @elseif($type === 'warning')
                <x-heroicon-s-exclamation-triangle class="h-5 w-5 {{ $classes['icon'] }}" />
            @elseif($type === 'danger')
                <x-heroicon-s-x-circle class="h-5 w-5 {{ $classes['icon'] }}" />
            @endif
        </div>
        <div class="ml-3 flex-1 {{ $classes['text'] }}">
            <p>{{ $message ?? $slot }}</p>
        </div>

        @if($dismissible)
        <div class="ml-auto pl-3">
            <div class="-mx-1.5 -my-1.5">
                <button type="button" @click="show = false" class="{{ $classes['text'] }} rounded-md p-1.5 hover:{{ $classes['bg'] }} focus:outline-none focus:ring-2 focus:ring-{{ $type }}-600 focus:ring-offset-2 focus:ring-offset-{{ $type }}-50">
                    <span class="sr-only">Dismiss</span>
                    <x-heroicon-s-x-mark class="h-5 w-5" />
                </button>
            </div>
        </div>
        @endif
    </div>
</div>
