<div>
    <!-- Alpine.js initialization for modals -->
    <div x-data="{ showModalId: null }" x-on:close-modals.window="showModalId = null"
        x-on:open-modal.window="showModalId = $event.detail">

        <div class="bg-white dark:bg-gray-800 shadow-xl sm:rounded-lg overflow-hidden">
            <!-- Header with filters and search -->
            <div class="p-6 border-b border-gray-200 dark:border-gray-700">
                <div
                    class="flex flex-col md:flex-row md:items-center md:justify-between space-y-3 md:space-y-0 md:space-x-4">
                    <div class="flex-1">
                        <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                            Modules Management
                        </h3>
                        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                            Manage your modules, activate or deactivate features
                        </p>
                    </div>
                </div>

                <div class="mt-4 md:mt-6">
                    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between space-y-3 sm:space-y-0">
                        <!-- Search - reduced width and added max-width -->
                        <div class="relative sm:max-w-xs w-full">
                            <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                <svg class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor"
                                    viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd"
                                        d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                        clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <input wire:model.debounce.300ms="search" type="search"
                                class="bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white text-sm rounded-lg focus:ring-info-500 focus:border-info-500 block w-full pl-10 p-2.5"
                                placeholder="Search modules...">
                        </div>

                        <!-- Filters - improved spacing and layout -->
                        <div class="flex flex-wrap sm:flex-nowrap items-center gap-3 sm:gap-4">
                            <select wire:model.live="type" id="type"
                                class="bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white text-sm rounded-lg focus:ring-info-500 focus:border-info-500 block p-2.5 min-w-[120px]">
                                <option value="">All Types</option>
                                <option value="core">Core</option>
                                <option value="addon">Addon</option>
                            </select>

                            <select wire:model.live="status" id="status"
                                class="bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white text-sm rounded-lg focus:ring-info-500 focus:border-info-500 block p-2.5 min-w-[120px]">
                                <option value="">All Status</option>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>

                            <select wire:model.live="perPage" id="perPage"
                                class="bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 text-gray-900 dark:text-white text-sm rounded-lg focus:ring-info-500 focus:border-info-500 block p-2.5 min-w-[120px]">
                                <option value="5">5 per page</option>
                                <option value="10">10 per page</option>
                                <option value="25">25 per page</option>
                                <option value="50">50 per page</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Flash messages with improved Alpine.js initialization -->
            <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
            <div class="mx-6 mt-4 p-4 bg-success-100 dark:bg-success-800 border border-success-200 dark:border-success-700 rounded-lg"
                x-data="{ show: true }" x-show="show" x-init="setTimeout(() => { show = false }, 5000)"
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 transform scale-95"
                x-transition:enter-end="opacity-100 transform scale-100"
                x-transition:leave="transition ease-in duration-300"
                x-transition:leave-start="opacity-100 transform scale-100"
                x-transition:leave-end="opacity-0 transform scale-95">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-success-700 dark:text-success-200 mr-2" fill="currentColor"
                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                clip-rule="evenodd"></path>
                        </svg>
                        <span class="text-success-700 dark:text-success-200"><?php echo e(session('success')); ?></span>
                    </div>
                    <button @click="show = false" type="button"
                        class="text-success-700 dark:text-success-200 hover:bg-success-200 dark:hover:bg-success-700 rounded-lg p-1.5 inline-flex h-8 w-8 focus:ring-2 focus:ring-success-400">
                        <span class="sr-only">Close</span>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </button>
                </div>
            </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <?php if(session()->has('error')): ?>
            <div class="mx-6 mt-4 p-4 bg-danger-100 dark:bg-danger-800 border border-danger-200 dark:border-danger-700 rounded-lg"
                x-data="{ show: true }" x-show="show" x-init="setTimeout(() => { show = false }, 5000)"
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 transform scale-95"
                x-transition:enter-end="opacity-100 transform scale-100"
                x-transition:leave="transition ease-in duration-300"
                x-transition:leave-start="opacity-100 transform scale-100"
                x-transition:leave-end="opacity-0 transform scale-95">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-danger-700 dark:text-danger-200 mr-2" fill="currentColor"
                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z"
                                clip-rule="evenodd"></path>
                        </svg>
                        <span class="text-danger-700 dark:text-danger-200"><?php echo e(session('error')); ?></span>
                    </div>
                    <button @click="show = false" type="button"
                        class="text-danger-700 dark:text-danger-200 hover:bg-danger-200 dark:hover:bg-danger-700 rounded-lg p-1.5 inline-flex h-8 w-8 focus:ring-2 focus:ring-danger-400">
                        <span class="sr-only">Close</span>
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </button>
                </div>
            </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!-- Table -->
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                    <thead class="text-xs text-gray-700 dark:text-gray-300 uppercase bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th scope="col" class="px-6 py-3">
                                <div class="flex items-center cursor-pointer" wire:click="sortBy('name')">
                                    Name
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'name'): ?>
                                    <svg class="w-3.5 h-3.5 ml-1.5" fill="currentColor" viewBox="0 0 20 20"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <!--[if BLOCK]><![endif]--><?php if($sortDirection === 'asc'): ?>
                                        <path fill-rule="evenodd"
                                            d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                            clip-rule="evenodd"></path>
                                        <?php else: ?>
                                        <path fill-rule="evenodd"
                                            d="M14.707 12.707a1 1 0 01-1.414 0L10 9.414l-3.293 3.293a1 1 0 01-1.414-1.414l4-4a1 1 0 011.414 0l4 4a1 1 0 010 1.414z"
                                            clip-rule="evenodd"></path>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </svg>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </th>
                            <th scope="col" class="px-6 py-3">
                                <div class="flex items-center cursor-pointer" wire:click="sortBy('type')">
                                    Type
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'type'): ?>
                                    <svg class="w-3.5 h-3.5 ml-1.5" fill="currentColor" viewBox="0 0 20 20"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <!--[if BLOCK]><![endif]--><?php if($sortDirection === 'asc'): ?>
                                        <path fill-rule="evenodd"
                                            d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                            clip-rule="evenodd"></path>
                                        <?php else: ?>
                                        <path fill-rule="evenodd"
                                            d="M14.707 12.707a1 1 0 01-1.414 0L10 9.414l-3.293 3.293a1 1 0 01-1.414-1.414l4-4a1 1 0 011.414 0l4 4a1 1 0 010 1.414z"
                                            clip-rule="evenodd"></path>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </svg>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </th>
                            <th scope="col" class="px-6 py-3">
                                <div class="flex items-center cursor-pointer" wire:click="sortBy('status')">
                                    Status
                                    <!--[if BLOCK]><![endif]--><?php if($sortField === 'status'): ?>
                                    <svg class="w-3.5 h-3.5 ml-1.5" fill="currentColor" viewBox="0 0 20 20"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <!--[if BLOCK]><![endif]--><?php if($sortDirection === 'asc'): ?>
                                        <path fill-rule="evenodd"
                                            d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                            clip-rule="evenodd"></path>
                                        <?php else: ?>
                                        <path fill-rule="evenodd"
                                            d="M14.707 12.707a1 1 0 01-1.414 0L10 9.414l-3.293 3.293a1 1 0 01-1.414-1.414l4-4a1 1 0 011.414 0l4 4a1 1 0 010 1.414z"
                                            clip-rule="evenodd"></path>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </svg>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </th>
                            <th scope="col" class="px-6 py-3">
                                <span class="sr-only">Actions</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                    <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="bg-white dark:bg-gray-800 border-b border-gray-200 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-700"
                        wire:key="<?php echo e($module['name']); ?>">
                        <td class="px-6 py-3 font-medium text-gray-900 dark:text-white">
                            <div class="flex gap-x-2">
                                <!-- Module icon - now aligned to the center of the content -->
                                <div class="self-center mr-2">
                                    <div
                                        class="flex-shrink-0 w-10 h-10 rounded-full bg-gradient-to-br from-purple-500 to-primary-600 flex items-center justify-center text-white">
                                        <?php echo e(substr($module['name'], 0, 1)); ?>

                                    </div>
                                </div>
                                <!-- Module name and info - stacked vertically -->
                                <div class="flex flex-col">
                                    <a href="<?php echo e(route('admin.modules.show', $module['name'])); ?>"
                                        class="text-info-600 dark:text-info-400 hover:underline">
                                        <?php echo e($module['name']); ?>

                                    </a>
                                    <p class="text-xs text-gray-600 dark:text-gray-400 line-clamp-1 mt-0.5">
                                        <?php echo e($module['info']['description'] ?? 'No description available'); ?>

                                    </p>
                                    <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                                        Version <?php echo e($module['info']['version'] ?? '1.0.0'); ?> | By
                                        <?php echo e($module['info']['author'] ?? 'Your Name'); ?>

                                    </div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <span
                                class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e(isset($module['info']['type']) && $module['info']['type'] === 'core' ? 'bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-300' : 'bg-info-100 text-info-800 dark:bg-info-900 dark:text-info-300'); ?>">
                                <?php echo e(isset($module['info']['type']) && $module['info']['type'] === 'core' ? 'Core' :
                                'Addon'); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4">
                            <span
                                class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($module['active'] ? 'bg-success-100 text-success-800 dark:bg-success-900 dark:text-success-300' : 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300'); ?>">
                                <?php echo e($module['active'] ? 'Active' : 'Inactive'); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 text-right space-x-2 whitespace-nowrap">
                            <!--[if BLOCK]><![endif]--><?php if(isset($module['info']['type']) && $module['info']['type'] === 'core'): ?>
                            <span class="text-gray-500 dark:text-gray-400 text-xs italic">Core
                                module</span>
                            <?php else: ?>
                            <div
                                class="inline-flex items-center divide-x divide-gray-300 dark:divide-gray-600 overflow-hidden rounded-md border border-gray-300 dark:border-gray-600">
                                <!--[if BLOCK]><![endif]--><?php if($module['active']): ?>
                                <button @click="showModalId = 'confirm-module-deactivation-<?php echo e($module['name']); ?>'"
                                    wire:key="deactivate-<?php echo e($module['name']); ?>" wire:loading.class="opacity-50"
                                    type="button"
                                    class="px-3 py-1 text-xs font-medium text-primary-600 dark:text-primary-400 hover:bg-primary-50 dark:hover:bg-gray-700 transition-colors duration-150">
                                    Deactivate
                                </button>
                                <?php else: ?>
                                <button @click="showModalId = 'confirm-module-activation-<?php echo e($module['name']); ?>'"
                                    wire:key="activate-<?php echo e($module['name']); ?>" wire:loading.class="opacity-50"
                                    type="button"
                                    class="px-3 py-1 text-xs font-medium text-primary-600 dark:text-primary-400 hover:bg-primary-50 dark:hover:bg-gray-700 transition-colors duration-150">
                                    Activate
                                </button>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                <button @click="showModalId = 'confirm-module-deletion-<?php echo e($module['name']); ?>'"
                                    class="px-3 py-1 text-xs font-medium text-danger-600 dark:text-danger-400 hover:bg-danger-50 dark:hover:bg-gray-700 transition-colors duration-150">
                                    Remove
                                </button>

                                <!-- Module Activation Confirmation Modal -->
                                <div x-show="showModalId === 'confirm-module-activation-<?php echo e($module['name']); ?>'"
                                    x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0"
                                    x-transition:enter-end="opacity-100" x-transition:leave="ease-in duration-200"
                                    x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
                                    class="fixed inset-0 z-50 overflow-y-auto" style="display: none;">
                                    <div
                                        class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                                        <div x-show="showModalId === 'confirm-module-activation-<?php echo e($module['name']); ?>'"
                                            x-transition:enter="ease-out duration-300"
                                            x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                                            x-transition:leave="ease-in duration-200"
                                            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
                                            class="fixed inset-0 transition-opacity" @click="showModalId = null">
                                            <div class="absolute inset-0 bg-gray-500 dark:bg-gray-900 opacity-75">
                                            </div>
                                        </div>

                                        <span class="hidden sm:inline-block sm:align-middle sm:h-screen">&#8203;</span>

                                        <div x-show="showModalId === 'confirm-module-activation-<?php echo e($module['name']); ?>'"
                                            x-transition:enter="ease-out duration-300"
                                            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                                            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                                            x-transition:leave="ease-in duration-200"
                                            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                                            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                                            class="inline-block align-bottom bg-white dark:bg-gray-800 rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                                            <div class="bg-white dark:bg-gray-800 px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                                                <div class="sm:flex sm:items-start">
                                                    <div
                                                        class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-success-100 dark:bg-success-900 sm:mx-0 sm:h-10 sm:w-10">
                                                        <svg class="h-6 w-6 text-success-600 dark:text-success-400"
                                                            fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                                            stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                        </svg>
                                                    </div>
                                                    <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                                                        <h3
                                                            class="text-lg leading-6 font-medium text-gray-900 dark:text-white">
                                                            Activate Module</h3>
                                                        <div class="mt-2">
                                                            <p class="text-sm text-gray-500 dark:text-gray-400">
                                                                Are you sure you want to activate
                                                                "<?php echo e($module['name']); ?>"?
                                                                This will enable all features of this
                                                                module.
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div
                                                class="bg-gray-50 dark:bg-gray-700 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                                                <button wire:click="activateModule('<?php echo e($module['name']); ?>')"
                                                    @click="showModalId = null" type="button"
                                                    class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-success-600 text-base font-medium text-white hover:bg-success-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-success-500 sm:ml-3 sm:w-auto sm:text-sm">
                                                    Activate
                                                </button>
                                                <button @click="showModalId = null" type="button"
                                                    class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 dark:border-gray-600 shadow-sm px-4 py-2 bg-white dark:bg-gray-800 text-base font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                                                    Cancel
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Module Deactivation Confirmation Modal -->
                                <div x-show="showModalId === 'confirm-module-deactivation-<?php echo e($module['name']); ?>'"
                                    x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0"
                                    x-transition:enter-end="opacity-100" x-transition:leave="ease-in duration-200"
                                    x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
                                    class="fixed inset-0 z-50 overflow-y-auto" style="display: none;">
                                    <div
                                        class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                                        <div x-show="showModalId === 'confirm-module-deactivation-<?php echo e($module['name']); ?>'"
                                            x-transition:enter="ease-out duration-300"
                                            x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                                            x-transition:leave="ease-in duration-200"
                                            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
                                            class="fixed inset-0 transition-opacity" @click="showModalId = null">
                                            <div class="absolute inset-0 bg-gray-500 dark:bg-gray-900 opacity-75">
                                            </div>
                                        </div>

                                        <span class="hidden sm:inline-block sm:align-middle sm:h-screen">&#8203;</span>

                                        <div x-show="showModalId === 'confirm-module-deactivation-<?php echo e($module['name']); ?>'"
                                            x-transition:enter="ease-out duration-300"
                                            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                                            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                                            x-transition:leave="ease-in duration-200"
                                            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                                            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                                            class="inline-block align-bottom bg-white dark:bg-gray-800 rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                                            <div class="bg-white dark:bg-gray-800 px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                                                <div class="sm:flex sm:items-start">
                                                    <div
                                                        class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-warning-100 dark:bg-warning-900 sm:mx-0 sm:h-10 sm:w-10">
                                                        <svg class="h-6 w-6 text-warning-600 dark:text-warning-400"
                                                            fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                                            stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                d="M9.879 7.519c1.171-1.025 3.071-1.025 4.242 0 1.172 1.025 1.172 2.687 0 3.712-.203.179-.43.326-.67.442-.745.361-1.45.999-1.45 1.827v.75M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9 5.25h.008v.008H12v-.008z" />
                                                        </svg>
                                                    </div>
                                                    <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                                                        <h3
                                                            class="text-lg leading-6 font-medium text-gray-900 dark:text-white">
                                                            Deactivate Module</h3>
                                                        <div class="mt-2">
                                                            <p class="text-sm text-gray-500 dark:text-gray-400">
                                                                Are you sure you want to deactivate
                                                                "<?php echo e($module['name']); ?>"?
                                                                This will disable all features provided by
                                                                this
                                                                module.
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div
                                                class="bg-gray-50 dark:bg-gray-700 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                                                <button wire:click="deactivateModule('<?php echo e($module['name']); ?>')"
                                                    @click="showModalId = null" type="button"
                                                    class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-warning-600 text-base font-medium text-white hover:bg-warning-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-warning-500 sm:ml-3 sm:w-auto sm:text-sm">
                                                    Deactivate
                                                </button>
                                                <button @click="showModalId = null" type="button"
                                                    class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 dark:border-gray-600 shadow-sm px-4 py-2 bg-white dark:bg-gray-800 text-base font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                                                    Cancel
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Module Deletion Confirmation Modal -->
                                <div x-show="showModalId === 'confirm-module-deletion-<?php echo e($module['name']); ?>'"
                                    x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0"
                                    x-transition:enter-end="opacity-100" x-transition:leave="ease-in duration-200"
                                    x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
                                    class="fixed inset-0 z-50 overflow-y-auto" style="display: none;">
                                    <div
                                        class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                                        <div x-show="showModalId === 'confirm-module-deletion-<?php echo e($module['name']); ?>'"
                                            x-transition:enter="ease-out duration-300"
                                            x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                                            x-transition:leave="ease-in duration-200"
                                            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
                                            class="fixed inset-0 transition-opacity" @click="showModalId = null">
                                            <div class="absolute inset-0 bg-gray-500 dark:bg-gray-900 opacity-75">
                                            </div>
                                        </div>

                                        <span class="hidden sm:inline-block sm:align-middle sm:h-screen">&#8203;</span>

                                        <div x-show="showModalId === 'confirm-module-deletion-<?php echo e($module['name']); ?>'"
                                            x-transition:enter="ease-out duration-300"
                                            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                                            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                                            x-transition:leave="ease-in duration-200"
                                            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                                            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                                            class="inline-block align-bottom bg-white dark:bg-gray-800 rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                                            <div class="bg-white dark:bg-gray-800 px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                                                <div class="sm:flex sm:items-start">
                                                    <div
                                                        class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-danger-100 dark:bg-danger-900 sm:mx-0 sm:h-10 sm:w-10">
                                                        <svg class="h-6 w-6 text-danger-600 dark:text-danger-400"
                                                            fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                                            stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                d="M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126zM12 15.75h.007v.008H12v-.008z" />
                                                        </svg>
                                                    </div>
                                                    <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                                                        <h3
                                                            class="text-lg leading-6 font-medium text-gray-900 dark:text-white">
                                                            Remove Module</h3>
                                                        <div class="mt-2">
                                                            <p class="text-sm text-gray-500 dark:text-gray-400">
                                                                Are you sure you want to remove this module?
                                                                This action cannot be undone.</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div
                                                class="bg-gray-50 dark:bg-gray-700 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                                                <button wire:click="removeModule('<?php echo e($module['name']); ?>')"
                                                    @click="showModalId = null" type="button"
                                                    class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-danger-600 text-base font-medium text-white hover:bg-danger-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-danger-500 sm:ml-3 sm:w-auto sm:text-sm">
                                                    Remove
                                                </button>
                                                <button @click="showModalId = null" type="button"
                                                    class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 dark:border-gray-600 shadow-sm px-4 py-2 bg-white dark:bg-gray-800 text-base font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                                                    Cancel
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr class="bg-white dark:bg-gray-800 border-b border-gray-200 dark:border-gray-700">
                        <td colspan="5" class="px-6 py-10 text-center text-sm text-gray-500 dark:text-gray-400">
                            <div class="flex flex-col items-center justify-center">
                                <svg class="w-12 h-12 text-gray-400 dark:text-gray-500 mb-4" fill="none"
                                    stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10">
                                    </path>
                                </svg>
                                <p class="mb-2 text-lg font-semibold">No modules found</p>
                                <p class="text-gray-500 dark:text-gray-400">Upload your first module to get
                                    started
                                </p>
                            </div>
                        </td>
                    </tr>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <!--[if BLOCK]><![endif]--><?php if($totalModules > 0): ?>
            <div class="p-6 border-t border-gray-200 dark:border-gray-700">
                <div class="flex flex-col sm:flex-row items-center justify-between gap-4">
                    <div class="text-sm text-gray-700 dark:text-gray-400">
                        Showing <span class="font-medium"><?php echo e($firstItem); ?></span> to <span class="font-medium"><?php echo e($lastItem); ?></span> of <span class="font-medium"><?php echo e($totalModules); ?></span> modules
                    </div>

                    <div class="inline-flex items-center justify-center">
                        <button wire:click="previousPage" wire:loading.attr="disabled"
                            class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded-l-md hover:bg-gray-50 dark:hover:bg-gray-700 focus:z-10 focus:outline-none focus:ring-1 focus:ring-primary-500 focus:border-primary-500 disabled:opacity-50"
                            <?php echo $page===1 ? 'disabled' : ''; ?>>
                            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414z"
                                    clip-rule="evenodd"></path>
                            </svg>
                            Previous
                        </button>
                        <button wire:click="nextPage" wire:loading.attr="disabled"
                            class="inline-flex items-center px-4 py-2 ml-1 text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded-r-md hover:bg-gray-50 dark:hover:bg-gray-700 focus:z-10 focus:outline-none focus:ring-1 focus:ring-primary-500 focus:border-primary-500 disabled:opacity-50"
                            <?php echo $page===$lastPage ? 'disabled' : ''; ?>>
                            Next
                            <svg class="w-5 h-5 ml-2" fill="currentColor" viewBox="0 0 20 20"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M7.293 14.707a1 1 0 010-1.414L10.586 10l-3.293-3.293a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z"
                                    clip-rule="evenodd"></path>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>
</div><?php /**PATH /media/corbital/web_data/laravel.local/nonsaas/vendor/corbital/module-manager/src/Providers/../../resources/views/livewire/module-list.blade.php ENDPATH**/ ?>